/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.ntfy.eventchain.AbstractChainedObject;
import java.io.Serializable;
import java.util.EventObject;

public abstract class DescriptiveObject
extends AbstractChainedObject
implements Serializable,
NotificationErrorIds {
    static final long serialVersionUID = -9059693857588009924L;
    private static final String TRACE_MASKT = "XNTYDSOT";
    private static final String TRACE_MASKF = "XNTYDSOF";
    private static final String TRACE_MASKD = "XNTYDSOD";
    private String _name;
    private String _description;
    private boolean _enabled = true;

    DescriptiveObject() {
    }

    public DescriptiveObject(String name, String description) {
        this._name = name;
        this._description = description;
    }

    public boolean pass(EventObject event) {
        return this.isEnabled();
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDeleted() {
        this.setEnabled(false);
        super.setDeleted();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this instanceof Startable && !this.isDeleted() && this.isEnabled() != enabled) {
            if (enabled) {
                if (!((Startable)((Object)this)).isStarted()) {
                    try {
                        ((Startable)((Object)this)).start();
                    }
                    catch (Exception e) {
                        new FrameworkLog(NotificationErrorIds._logInfo, -32737, e).log(LogAttributes.INFO_LOG);
                    }
                }
            } else if (((Startable)((Object)this)).isStarted()) {
                try {
                    ((Startable)((Object)this)).stop();
                }
                catch (Exception e) {
                    new FrameworkLog(NotificationErrorIds._logInfo, -32736, e).log(LogAttributes.INFO_LOG);
                }
            }
        }
        this._enabled = enabled;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getName().equals(((DescriptiveObject)obj).getName());
    }

    public String toString() {
        return this.getClass().getName() + "[ " + this.parms() + " ]";
    }

    public StringBuffer parms() {
        StringBuffer parms = new StringBuffer();
        parms.append("name=");
        parms.append(this.getName());
        parms.append(", desc=");
        parms.append(this.getDescription());
        return parms;
    }
}

